Function Main As String
' Show molecular tree methods (contd.)
' Convert all C=C,C=N fragments in the molecules of current page to N-N

' THE EXAMPLE ILLUSTRATES THE USE OF:
'   AddFromCS
'   Structures
'   Molecule
'   GetBondOrder
'   SetBondOrder
'   Atom1
'   Atom2
'   SetMass
'   GetElNumber
'   SetElNumber

Dim i,j,n,nd,k,ib,nb,elat1,elat2,nmatchbonds As Integer
Dim Diagram,Struc,Page,Bnd,At1,At2 As Object, abmatch As Boolean
Const title="SHOW MOLECULAR-TREE OBJECTS METHODS"
  k=MBB_OK + MBI_INFORMATION

  'Get a page
  Page=ActiveDocument.ActivePage
  'Process all the molecules
  With Page.Diagrams
    'Check if there are molecules....
    If .Count<1 Then
      i=MessageBox("Your page contains no molecules, sorry", title, k)
      Goto ShutDown
    EndIf
    i=MessageBox("Press OK to convert all C=C and C=N bonds to N-N", title, k)
    'Process all the molecules
    For Each Diagram In .Self
      'Get molecule from diagram
      Struc=Assemblies.AddFromCS(Diagram).Structures.Item(1)
      If Struc<>NULL Then
        nb=Struc.Molecule.Count
        nmatchbonds=0
        'Check all the bonds in this molecule
        For ib=1 To nb
          Bnd=Struc.Molecule.Item(ib) : At1=Bnd.Atom1 : At2=Bnd.Atom2
          elat1=At1.GetElNumber : elat2=At2.GetElNumber
          abmatch= (elat1=6) And (elat2=6)
          abmatch= abmatch Or ( (elat1=7) And (elat2=6) )
          abmatch= abmatch Or ( (elat1=6) And (elat2=7) )
          abmatch= abmatch And (Bnd.GetBondOrder=BO_DOUBLE)
          If abmatch Then
            'bond matches our criteria, modify the fragment
            nmatchbonds=nmatchbonds+1
            At1.SetElNumber(7) : At1.SetMass(14.0067)
            At2.SetElNumber(7) : At2.SetMass(14.0067)
            Call Bnd.SetBondOrder(BO_SINGLE)
          EndIf
        Next ib
        If nmatchbonds>0 Then Diagram.Depict(Struc)
      EndIf
    Next Diagram
  End With
ShutDown:
  Main="Demo completed"
End Function